// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __TopLevelConfiguration_h__
#define __TopLevelConfiguration_h__

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

class String;
class ConstantRecursiveSlotValue;
class InputDevice;

// The default configuration for a TopLevel had better be a
// TopLevelConfiguration.
// FIXME Otherwise, what goes wrong?  I've forgotten.

class TopLevelConfiguration
  : public Configuration
{
  struct TopLevelConfigurationData;
  TopLevelConfigurationData *m_data;
public:
  ~TopLevelConfiguration ();
  // The windowSystem is the string used to find the drawers for the various
  // physics object.  For instance, if windowSystem is "X", and there's a
  // physics object called "Ball" around, then the result from getObjectDrawer
  // will find the class XBallDrawer.
  //
  // inputDriverPrefixes is a list of prefixes used to find input drivers,
  // which are factories in the protocol InputDevicesFactory.  For example, if
  // you're running an X server under Linux, then inputDriverPrefixes should
  // probably be the dynavec ("Linux", "X"), so you'll get input drivers that
  // are either Linux-specific or X-specific.  If there are factories like
  // XKeyboardMouseDevices or LinuxSpaceorbDevices registered as a
  // InputDevicesFactory's, then they will be run (because their factory names
  // have initial substrings that are on the list) and any InputDevices they
  // find will appear in the list returned by getInputDevices, and the
  // configurations for the corresponding devices will appear in the list
  // returned by getInputConfigurations. 
  TopLevelConfiguration (const String &windowSystem,
			 const Dynavec <String> &inputDriverPrefixes);
  // The constructor for TopLevelConfiguration takes a string and
  // arranges to return a plausible ObjectDrawer here.  The
  // defaultConfiguration function for a TopLevel factory doesn't have
  // to fill this in, all it has to do is pass the right string to the
  // constructor. 
  ConstantRecursiveSlotValue *getObjectDrawer ();

  // All of the input devices we found.
  Dynavec <SP <InputDevice> > getInputDevices ();
  // All of the configurations of input devices we found.  Will be the same
  // length as the list returned by getInputDevices, and the i'th element of
  // the result from getInputConfiguration can be edited to reconfigure the
  // i'th element of the result from getInputDevices.
  Dynavec <SP <Configuration> > getInputConfigurations ();

  TopLevelConfiguration (const TopLevelConfiguration &tlc);
  SP<Configuration> copy () const;
  bool hasTheSameTypeAs(const Configuration *c) const;
};
#endif
