// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __TopLevelConfiguration_h__
#include "TopLevelConfiguration.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __ConstantRecursiveSlotValue_h__
#include "ConstantRecursiveSlotValue.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __stdlib_h__
#include <stdlib.h>
#define __stdlib_h__
#endif

#ifndef __Configurable_h__
#include "Configurable.h"
#endif

#ifndef __InputDevice_h__
#include "InputDevice.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __InputDevicesFactory_h__
#include "InputDevicesFactory.h"
#endif

#ifndef __ConstantVectorSlotValue_h__
#include "ConstantVectorSlotValue.h"
#endif

#ifndef __InputDeviceConfiguration_h__
#include "InputDeviceConfiguration.h"
#endif

namespace {
  String objectDrawerName () {
    return "Object Drawer";
  }
  String inputName () {
    return "Input Devices";
  }
  // UselessFactory is a placeholder for the ConstantVectorSlotValue we'll use
  // to store the input device configurations.
  // We also have one of these in the DispatcherConfigurations.
  // FIXME Make a slot with a vector of configurations
  // or maybe just a slot with a configuration, and then use a VectorSlotValue
  // on that.  That way we wouldn't have to represent it as a
  // RecursiveSlotValue with an unused factory.
  class UselessFactory
    : public Factory
  {
    SP<Configuration> m_conf;
  public:
    UselessFactory (Configuration * conf)
      : Factory ("Useless (this string should not be seen)"),
	m_conf (conf)
    {}
    SP<Configuration> defaultConfiguration () const {
      return m_conf;
    }
    SP<Configurable> makeIt (SP<Configuration> conf) const {
      (void) conf;
      abort ();
      // Compiler doesn't know that abort doesn't return.
      return 0;
    }
  };
};

struct TopLevelConfiguration::TopLevelConfigurationData {
  Dynavec <SP <InputDevice> > m_inputDevices;
};

TopLevelConfiguration::~TopLevelConfiguration () {
  assert (m_data);
  delete m_data;
  m_data = 0;
}

TopLevelConfiguration::TopLevelConfiguration
(const String &windowSystem,
 const Dynavec <String> &inputDriverPrefixes)
  : m_data (NEW (TopLevelConfigurationData ()))
{
  initializeSlot (objectDrawerName (),
		  NEW (ConstantRecursiveSlotValue
		       ("ObjectDrawer",
			windowSystem+"ObjectDrawer")));
  InputDevicesFactory::openDevices (inputDriverPrefixes,
				    m_data->m_inputDevices);
  Dynavec <SP <SlotValue> > inputCRSVs;
  for (int i = 0; i < m_data->m_inputDevices.size(); i++) {
    SP<ConstantRecursiveSlotValue> newcrsv =
      // Give a protocol name here that looks nice on the printout.  It isn't
      // used for anything else.
      NEW (ConstantRecursiveSlotValue
	   ("InputDevice",
	    // InputDeviceConfiguration.h is needed for the next line.
	    NEW (UselessFactory (&*m_data->m_inputDevices[i]->getConf()))));
    inputCRSVs.push (&*newcrsv);
  }
  initializeSlot (inputName (), NEW (ConstantVectorSlotValue (inputCRSVs)));
}

ConstantRecursiveSlotValue *TopLevelConfiguration::getObjectDrawer () {
  return ConstantRecursiveSlotValue::getSlotValue (this, objectDrawerName());
}

TopLevelConfiguration::TopLevelConfiguration (const TopLevelConfiguration &tlc)
  : Configuration (tlc),
    m_data (NEW (TopLevelConfigurationData (*tlc.m_data)))
{}

SP<Configuration> TopLevelConfiguration::copy () const {
  return NEW (TopLevelConfiguration (*this));
}

bool TopLevelConfiguration::hasTheSameTypeAs(const Configuration *c) const {
  return 0 != dynamic_cast <const TopLevelConfiguration *> (c);
}

Dynavec <SP <InputDevice> > TopLevelConfiguration::getInputDevices () {
  return m_data->m_inputDevices;
}
