// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __SimpleGrabbingActionConfiguration_h__
#define __SimpleGrabbingActionConfiguration_h__

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __Event_h__
#include "Event.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

class Factory;
class Configuration;
class SimpleGrabbingActionConfiguration
  : public ActionConfiguration
{
  struct SGACData;
  SGACData *m_data;
public:
  // Pass the currently executing factory to grabIfFirst, and if we aren't
  // already executing a grab, it will make an appropriate grab.  Uses the
  // copy () method to duplicate the current configuration for incorporating it
  // into the grab.
  void grabIfFirst (const Factory *f);
  // Whether this is the first event.
  bool isFirst () const;
  // Whether this is the last repetition of this command as part of a grab.
  bool isLast () const;
  // The button that we did/will grab.
  Event::Button grabbedButton () const;

  SimpleGrabbingActionConfiguration ();
  SimpleGrabbingActionConfiguration
  (const SimpleGrabbingActionConfiguration &c);
  ~SimpleGrabbingActionConfiguration ();
  bool hasTheSameTypeAs (const Configuration *c) const;
  SP<Configuration> copy () const;
};
#endif
