// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __SimpleGrabbingActionConfiguration_h__
#include "SimpleGrabbingActionConfiguration.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __Event_h__
#include "Event.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

struct SimpleGrabbingActionConfiguration::SGACData {
  bool m_firstTime;
  Event::Button m_firstButton;
  SGACData () {
    m_firstTime = true;
  }
};

void SimpleGrabbingActionConfiguration::grabIfFirst (const Factory *f) {
  if (isFirst ()) {
    SP<TopLevel> top = getTopLevel ();
    // I don't think the protocol in the RSV matters much, since we won't be
    // reconfiguring it. 
    SP<RecursiveSlotValue> rsv = NEW (RecursiveSlotValue ("Action", f));
    SP<SimpleGrabbingActionConfiguration> grabConf =
      dynamic_cast <SimpleGrabbingActionConfiguration *> (&*copy ());
    assert (grabConf);
    grabConf->m_data->m_firstTime = false;
    grabConf->m_data->m_firstButton = top->getEvent()->getButton ();
    rsv->setConfiguration (&*grabConf);
    top->grab (rsv);
  }
}

bool SimpleGrabbingActionConfiguration::isFirst () const {
  return m_data->m_firstTime;
}

bool SimpleGrabbingActionConfiguration::isLast () const {
  SP<const TopLevel> top = getTopLevel ();
  SP<const Event> e = top->getEvent();
  return e->getButton() == grabbedButton() && !e->isDown();
}

Event::Button SimpleGrabbingActionConfiguration::grabbedButton () const {
  if (isFirst()) {
    return getTopLevel()->getEvent()->getButton ();
  } else {
    return m_data->m_firstButton;
  }
}

SimpleGrabbingActionConfiguration::SimpleGrabbingActionConfiguration ()
  : m_data (NEW (SGACData ()))
{}

SimpleGrabbingActionConfiguration::SimpleGrabbingActionConfiguration
(const SimpleGrabbingActionConfiguration &c)
  : ActionConfiguration (c),
    m_data (NEW (SGACData (*c.m_data)))
{}

SimpleGrabbingActionConfiguration::~SimpleGrabbingActionConfiguration () {
  assert (m_data);
  delete m_data;
  m_data = 0;
}

bool SimpleGrabbingActionConfiguration::hasTheSameTypeAs
(const Configuration *c)
  const
{
  return 0 != dynamic_cast <const SimpleGrabbingActionConfiguration *> (c);
}

SP<Configuration> SimpleGrabbingActionConfiguration::copy () const {
  return NEW (SimpleGrabbingActionConfiguration (*this));
}
