// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __SceneLoader_h__
#include "SceneLoader.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __VectorSceneConfiguration_h__
#include "VectorSceneConfiguration.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __SceneLoaderConfiguration_h__
#include "SceneLoaderConfiguration.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

namespace {

class VectorSceneLoader : public SceneLoader {
public:
  VectorSceneLoader (const SP<VectorSceneConfiguration> &c)
  {
    for (int i = 0; i < c->size(); i++) {
      SP<RecursiveSlotValue> rsv = (*c)[i];
      assert (rsv);
      SP<SceneLoaderConfiguration> slc =
	dynamic_cast <SceneLoaderConfiguration *>
	(&*rsv->getConfiguration()
	 // Make a copy because we're going to translate it and we
	 // don't want the translations to accumulate.
	 ->copy ());
      assert (slc);
      slc->setTopLevel (c->getTopLevel ());
      slc->setWhere (slc->getWhere() + c->getWhere ());
      SP<SceneLoader> sl = dynamic_cast <SceneLoader *>
	(&*(rsv->getFactory()->makeIt (&*slc)));
      // Avoid reference cycle.
      // FIXME I do not believe this is needed any more.
      // slc->setTopLevel (0);
      assert (sl);
      if (sl->isMessage ()) {
	setMessage (sl->getMessage());
      }
      if (sl->isProblem ()) {
	setProblem (sl->getProblem());
	break;
      }
    }
  }
};

class VectorSceneFactory : public Factory {
public:
  VectorSceneFactory () : Factory ("VectorSceneLoader") {}
  SP<Configuration> defaultConfiguration () const {
    return NEW (VectorSceneConfiguration ());
  }
  SP<Configurable> makeIt (const SP<Configuration> c) const {
    VectorSceneConfiguration *conf =
      dynamic_cast <VectorSceneConfiguration *> (&*c);
    assert (conf);
    return NEW (VectorSceneLoader (conf));
  }
};
  
static const bool useless =
(FactoryTable::store ("SceneLoader", NEW (VectorSceneFactory ())),
 true);
  
} // namespace
