// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#include "VectorSceneConfiguration.h"

#ifndef __VectorSlotValue_h__
#include "VectorSlotValue.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

VectorSceneConfiguration::VectorSceneConfiguration () {
  SP<RecursiveSlotValue> rsv =
    NEW (RecursiveSlotValue ("SceneLoader", "TestSceneLoader"));
  Dynavec <SP <SlotValue> > v;
  v.push (&*rsv);
  initializeSlot ("Scenes", NEW (VectorSlotValue (&*rsv, v)));
}

SP<const VectorSlotValue> VectorSceneConfiguration::getVectorSlotValue () const
{
  SP<const SlotValue> r1 = getSlot ("Scenes");
  const VectorSlotValue * result =
    dynamic_cast <const VectorSlotValue *> (&*r1);
  assert (result);
  return result;
}

SP<VectorSlotValue> VectorSceneConfiguration::getVectorSlotValue () {
  SP<SlotValue> r1 = getSlot ("Scenes");
  VectorSlotValue * result =
    dynamic_cast <VectorSlotValue *> (&*r1);
  assert (result);
  return result;
}

SP<RecursiveSlotValue> VectorSceneConfiguration::operator[] (int where) {
  SP<VectorSlotValue> vsv = getVectorSlotValue();
  assert (vsv);
  SP<SlotValue> sv = (*vsv) [where];
  assert (sv);
  SP<RecursiveSlotValue> result =
    dynamic_cast <RecursiveSlotValue *> (&*sv);
  assert (result);
  return result;
}

int VectorSceneConfiguration::size () const {
  return getVectorSlotValue()->size();
}

VectorSceneConfiguration::VectorSceneConfiguration (const VectorSceneConfiguration &v)
  : SceneLoaderConfiguration (v)
{}

SP<Configuration> VectorSceneConfiguration::copy () const {
  return NEW (VectorSceneConfiguration (*this));
}

bool VectorSceneConfiguration::hasTheSameTypeAs (const Configuration *c) const
{
  return 0 != dynamic_cast <const VectorSceneConfiguration *> (c);
}
