// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __SceneLoader_h__
#include "SceneLoader.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __TestSceneConfiguration_h__
#include "TestSceneConfiguration.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __PhysicsObject_h__
#include "PhysicsObject.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

namespace {

class TestSceneLoader : public SceneLoader {
public:
  TestSceneLoader (const SP<TestSceneConfiguration> c) {
    SP<SceneGraph> sg = c->getTopLevel()->getSceneGraph ();
    assert (sg);
    SP<PhysicsObject> po = c->makeIt ();
    assert (po);
    int size = c -> getCubeSize ();
    assert (size > 0);
    Float spacing = c -> getCubeSpace ();
    assert (spacing > 0);
    Vec3 origin = c -> getWhere ();
    Dynavec <Float> state;
    for (int i = 0; i < size; i++) {
      for (int j = 0; j < size; j++) {
	for (int k = 0; k < size; k++) {
	  po->plausibleState(state);
	  po->translate (state,
			 origin + Vec3 (i*spacing, j*spacing, k*spacing));
	  sg->addObject (po, state);
	}
      }
    }
  }
};

class TestSceneFactory : public Factory {
public:
  TestSceneFactory () : Factory ("TestSceneLoader") {}
  SP<Configuration> defaultConfiguration () const {
    return NEW (TestSceneConfiguration ());
  }
  SP<Configurable> makeIt (const SP<Configuration> c) const {
    TestSceneConfiguration *conf =
      dynamic_cast <TestSceneConfiguration *> (&*c);
    assert (conf);
    return NEW (TestSceneLoader (conf));
  }
};

static const bool useless =
 (FactoryTable::store ("SceneLoader", NEW (TestSceneFactory ())),
  true);

} // namespace
