// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#include "TestSceneConfiguration.h"

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __PositiveIntSlotValue_h__
#include "PositiveIntSlotValue.h"
#endif

#ifndef __PositiveFloatSlotValue_h__
#include "PositiveFloatSlotValue.h"
#endif

#ifndef __Vec3SlotValue_h__
#include "Vec3SlotValue.h"
#endif

#ifndef __PhysicsObject_h__
#include "PhysicsObject.h"
#endif

// Don't have a static variable with a string, it looks like a memory leak.
// So use functions instead.
#ifndef __SlotValue_h__
#include "SlotValue.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

static const String objName () {
  return "What to Build";
}

static const String cubeSize () {
  return "How many objects along edges of cube";
}

static const String cubeSpace () {
  return "Distance between objects";
}

TestSceneConfiguration::TestSceneConfiguration ()
{
  initializeSlot (objName (),
		  NEW (RecursiveSlotValue ("PhysicsObject",
					   "RedBouncingBall")));
  ref ();
  setWhere (Vec3 (0, 0, 15));
  deref ();
  const int redcubeSize =
#ifdef NDEBUG
    8
#else
    3
#endif
    ;
  initializeSlot (cubeSize (), NEW (PositiveIntSlotValue (redcubeSize)));
  initializeSlot (cubeSpace (), NEW (PositiveFloatSlotValue (1.0)));
}

SP<PhysicsObject> TestSceneConfiguration::makeIt () const {
  SP<Configurable> r = getRecursiveSlotValue ()->makeIt ();
  SP<PhysicsObject> result = dynamic_cast <PhysicsObject *> (&*r);
  assert (result);
  return result;
}

void TestSceneConfiguration::setRecursiveSlotValue (SP<RecursiveSlotValue> r) {
  RecursiveSlotValue::setSlotValue (this, objName (), r);
}

SP<RecursiveSlotValue> TestSceneConfiguration::getRecursiveSlotValue () {
  return RecursiveSlotValue::getSlotValue (SP<Configuration> (this),
					   objName ());
}

SP<const RecursiveSlotValue> TestSceneConfiguration::getRecursiveSlotValue ()
  const
{
  return RecursiveSlotValue::getSlotValue (this, objName ());
}

int TestSceneConfiguration::getCubeSize () const {
  return PositiveIntSlotValue::getSlot (this, cubeSize ());
}

void TestSceneConfiguration::setCubeSize (int s) {
  PositiveIntSlotValue::setSlot (this, cubeSize (), s);
}

Float TestSceneConfiguration::getCubeSpace () const {
  return PositiveFloatSlotValue::getSlot (this, cubeSpace ());
}

void TestSceneConfiguration::setCubeSpace (Float s) {
  PositiveFloatSlotValue::setSlot (this, cubeSpace (), s);
}

SP<Configuration> TestSceneConfiguration::copy () const {
  return NEW (TestSceneConfiguration (*this));
}
bool TestSceneConfiguration::hasTheSameTypeAs (const Configuration *c)
  const
{
  return 0 != dynamic_cast <const TestSceneConfiguration *> (c);
}

String TestSceneConfiguration::unParse () const {
  return getRecursiveSlotValue()->unParse();
}
