// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __StreamUtil_h__
#define __StreamUtil_h__

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __Float_h__
#include "Float.h"
#endif

class String;
class ostream;
class Vec3;
class Quaternion;

struct StreamUtil {
  static void promptRead (const char *prompt, int &result);
  // Next one complains and re-prompts if the result would otherwise
  // be out of range.  Result will be >= min and < max.
  static void promptRead (const char *prompt, int &result,
			  int min, int max);
  static void promptRead (const char *prompt, bool &result);
  static void promptRead (const char *prompt, Float &result);
  static void promptRead (const char *prompt, String &result);
  static void promptRead (const char *prompt, Vec3 &result);
  static void promptRead (const char *prompt, Quaternion &result);
  // promptReadNew prompts for a new value of something and reads it in.
  // Used in the generic slot implementation template ScalarSlotValue.
  template <class T> static void promptReadNew (T &result) {
    promptRead ("What do you want the new value to be? ", result);
  }
  static void promptReadNew (Vec3 &result);
  static void promptReadNew (Quaternion &result);
  static void printTableau (ostream &o, Dynavec <Dynavec <String> > &t);
  // Scan to the end of the line on the given file.  Should be used
  // interactively.  Stops on and then clears any end-of-file condition.
  static void endLine ();
  // Read a character for a menu choice.  Read
  // an entire line, and deal with EOF by asking them to try again.
  // Does not convert to lower case.
  static char readMenuCh ();
};
#endif
