// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __Configurable_h__
#include "Configurable.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __SelectionManager_h__
#include "SelectionManager.h"
#endif

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __LinkManager_h__
#include "LinkManager.h"
#endif

#ifndef __PhysicsObject_h__
#include "PhysicsObject.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

namespace {
  class ToggleConnectedSelection
    : public Factory
  {
  public:
    ToggleConnectedSelection ()
      : Factory ("ToggleConnectedSelection")
    {}
    SP<Configuration> defaultConfiguration () const {
      return NEW (ActionConfiguration ());
    }
    SP<Configurable> makeIt (const SP<Configuration> c) const {
      SP<ActionConfiguration> conf =
	dynamic_cast <ActionConfiguration *> (&*c);
      assert (conf);
      SP<TopLevel> top = conf->getTopLevel ();
      // The index of the selected object.
      int index;
      SP<Action> result = NEW (Action ());
      SP<SceneGraph> sg = top->getSceneGraph ();
      {
	// The point in space where the user clicked on the selected object.
	Vec3 intersectionPoint;
	if (!top->findUnderMouse (index, intersectionPoint)) {
	  result->setProblem ("There is no object under the mouse; "
			      "selection unchanged");
	}
      }
      Dynavec <bool> moleculeSet;
      const int maxIndex = sg->maxIndex ();
      if (!result->isProblem ()) {
	moleculeSet.extendTo (maxIndex, false);
	Dynavec <int> oldMolecule;
	oldMolecule.push (index);
	Dynavec <int> newMolecule;
	SP<LinkManager> lm = sg->getLinkManager ();
	for (;;) {
	  bool anyAdded = false;
	  newMolecule.extendTo (0);
	  // oldMolecule is our work queue.  newMolecule is what we'll work on
	  // next time around the loop.  If any elements in oldMolecule aren't
	  // already in the result, put them in the result and put their
	  // neighbors in newMolecule.
	  for (int i = 0; i < oldMolecule.size (); i++) {
	    const int s = oldMolecule [i];
	    // Note the call to PhysicsObject::isSelectable rather than
	    // SelectionManager::isSelectable.  We probably want to select
	    // invisible objects here, since they are likely to have the
	    // proper connections.
	    if (!moleculeSet [s] && sg->object(s)->isSelectable ()) {
	      moleculeSet [s] = true;
	      anyAdded = true;
	      int count;
	      const int *links;
	      lm->getLinks (s, count, links);
	      for (int i = 0; i < count ; i++) {
		const int thisLink = links [i];
		if (-1 != thisLink) {
		  newMolecule.push (thisLink);
		}
	      }
	    }
	  }
	  oldMolecule = newMolecule;
	  if (!anyAdded) break;
	}
	// Get the selection into selectionSet.
	Dynavec <bool> selectionSet;
	selectionSet.extendTo (maxIndex, false);
	{
	  Dynavec <int> selection;
	  SelectionManager::getSelection (selection);
	  for (int i = 0; i < selection.size (); i++) {
	    selectionSet [selection [i]] = true;
	  }
	}
	// Now selectionSet [i] is true iff object i is selected.
	bool allMoleculeIsSelected = true;
	for (int i = 0; i < maxIndex; i++) {
	  if (moleculeSet [i] && !selectionSet [i]) {
	    allMoleculeIsSelected = false;
	    break;
	  }
	}
	// Now allMoleculeIsSelected is true iff the entire molecule that they
	// clicked on is selected.
	// If all of the molecule is already selected, then deselect it.
	// Otherwise select it.  This code is redundant with
	// SelectFrustrum.cpp. 
	for (int i = 0; i < maxIndex; i++) {
	  if (moleculeSet [i]) {
	    selectionSet [i] = !allMoleculeIsSelected;
	  }
	}
	{
	  // Select selectionSet.
	  Dynavec <int> selection;
	  for (int i = 0; i < maxIndex; i++) {
	    if (selectionSet [i]) {
	      selection.push (i);
	    }
	  }
	  SelectionManager::setSelection (sg, selection);
	}
      }
      return &*result;
    }
  };
  const bool useless =
  (FactoryTable::store ("Action", NEW (ToggleConnectedSelection ())),
   true);
}
