// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __SelectionManager_h__
#include "SelectionManager.h"
#endif

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

namespace {
  class SelectionInvisible
    : public TypedFactory<ActionConfiguration, Action>
  {
  public:
    SelectionInvisible ()
      : TypedFactory <ActionConfiguration, Action> ("SelectionInvisible")
    {}
    SP<ActionConfiguration> typedDefaultConfiguration () const {
      return NEW (ActionConfiguration ());
    }
    SP<Action> makeIt (ActionConfiguration * conf) const {
      Dynavec <int> selection;
      SelectionManager::getSelection (selection);
      SP<SceneGraph> sg = conf->getTopLevel ()->getSceneGraph ();
      SP<Action> result = NEW (Action ());
      if (selection.size ()) {
	SelectionManager::setSelection (sg, Dynavec <int> ());
	Dynavec <int> oldInvisible;
	SelectionManager::getInvisible (oldInvisible);
	for (int i = 0; i < oldInvisible.size(); i++) {
	  selection.push (oldInvisible [i]);
	}
	// We might have with redundant elements in selection now.
	// setInvisible can cope with that.
	SelectionManager::setInvisible (sg, selection);
      } else {
	SelectionManager::getInvisible (selection);
	SelectionManager::setSelection (sg, selection);
	SelectionManager::setInvisible (sg, Dynavec <int> ());
	result->setMessage ("Nothing selected, so made all invisible "
			    "atoms visible and selected them");
      }
      return result;;
    }
  };
  const bool useless =
  (FactoryTable::store ("Action", NEW (SelectionInvisible ())),
   true);
}
