// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __SelectionManager_h__
#include "SelectionManager.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __VecUtil_h__
#include "VecUtil.h"
#endif

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __PhysicsObject_h__
#include "PhysicsObject.h"
#endif

namespace {
  class SelectAddUnderMouse
    : public Factory
  {
  public:
    SelectAddUnderMouse ()
      : Factory ("SelectAddUnderMouse")
    {}
    SP<Configuration> defaultConfiguration () const {
      return NEW (ActionConfiguration ());
    }
    SP<Configurable> makeIt (const SP<Configuration> c) const {
      SP<ActionConfiguration> conf =
	dynamic_cast <ActionConfiguration *> (&*c);
      assert (conf);
      SP<TopLevel> top = conf->getTopLevel ();
      SP<SceneGraph> sg = top->getSceneGraph ();
      SP<Action> result = NEW (Action ());
      int index;
      Vec3 intersectionPoint;
      if (top->findUnderMouse (index, intersectionPoint)) {
	Dynavec <int> selected;
	SelectionManager::getSelection (selected);
	if (VecUtil::find (index, selected)) {
	  result->setMessage (String ("Object ")+index+
			      " is already selected; deselecting it");
	  VecUtil::remove (index, selected);
	} else if (sg->object(index)->isSelectable ()) {
	  result->setMessage (String ("Adding object ") + index +
			      " to the selection");
	  selected.push (index);
	} else {
	  result->setProblem (String ("Object ")+index+
			      " is not selectable.  Selection unchanged.");
	}
	SelectionManager::setSelection (sg, selected);
      } else {
	result->setMessage ("Mouse not over an object, selection unchanged");
      }
      return &*result;
    }
  };
  const bool useless =
  (FactoryTable::store ("KeyboardMouseAction", NEW (SelectAddUnderMouse ())),
   true);
}
