// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __Configurable_h__
#include "Configurable.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __LinkManager_h__
#include "LinkManager.h"
#endif

#ifndef __SelectionManager_h__
#include "SelectionManager.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __PhysicsObject_h__
#include "PhysicsObject.h"
#endif

#ifndef __Float_h__
#include "Float.h"
#endif

namespace {
  // Copy the selection.  When we're done, the original and the copy will be in
  // the same place, the copy will be selected, and the original will not be
  // touched.  All links between copied objects and other copied objects will
  // be preserved.  Links between copied objects and non-copied objects will be
  // broken.
  //
  // You might want to use this with a macro that moves the copy a little bit
  // immediately after it is copied.  Otherwise people will not be able to see
  // that the copy has been made.
  class CopySelection
    : public Factory
  {
  public:
    CopySelection ()
      : Factory ("CopySelection")
    {}
    SP<Configuration> defaultConfiguration () const {
      return NEW (ActionConfiguration ());
    }
    SP<Configurable> makeIt (const SP<Configuration> c) const {
      SP<ActionConfiguration> conf =
	dynamic_cast <ActionConfiguration *> (&*c);
      assert (conf);
      SP<TopLevel> top = conf->getTopLevel ();
      SP<SceneGraph> sg = top->getSceneGraph ();
      Dynavec <int> selection;
      SelectionManager::getSelection (selection);
      SP<Action> result = NEW (Action ());
      if (0 == selection.size ()) {
	result->setProblem ("Nothing was copied because nothing "
			    "was selected.");
      } else {
	// Mapping from old indices to new indices, so we can copy the links.
	Dynavec <int> oldToNew;
	oldToNew.extendTo (sg->maxIndex(), -1);
	{
	  Dynavec <Float> stateCopy;
	  for (int i = 0; i < selection.size(); i++) {
	    const int s = selection [i];
	    stateCopy.extendTo (0);
	    for (int j = 0; j < sg->object(s)->stateSize(); j++) {
	      stateCopy.push (sg->objectState(s)[j]);
	    }
	    const int copyS = sg->addObject (sg->object (s), stateCopy);
	    if (-1 == copyS) {
	      result->setProblem (String ("Failed to add the copy of object ")
				  + s + " to the scene graph");
	    }
	    oldToNew[s] = copyS;
	  }
	}
	{ // Copy the links.
	  SP<LinkManager> lm = sg->getLinkManager();
	  Dynavec <int> newLinks;
	  for (int i = 0; i < selection.size(); i++) {
	    const int s = selection [i];
	    int count;
	    const int *oldLinks;
	    lm->getLinks (s, count, oldLinks);
	    if (count > 0 && -1 != oldToNew [s]) {
	      newLinks.extendTo (0);
	      for (int j = 0; j < count; j++) {
		const int old = oldLinks [j];
		if ((-1 == old) || (-1 == oldToNew [old])) {
		  newLinks.push (-1);
		} else {
		  newLinks.push (oldToNew [old]);
		}
	      }
	      lm->setLinks (oldToNew [s], newLinks);
	    }
	  }
	}
	// Select the copy.  oldToNew could conceivably have some -1's in it,
	// but that doesn't cause trouble, and it usually won't be the case
	// anyway.
	SelectionManager::setSelection (sg, oldToNew);
      }
      return &*result;
    }
  };
  const bool useless =
  (FactoryTable::store ("Action", NEW (CopySelection ())),
   true);
}
