// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __AnyOrbMove_h__
#include "AnyOrbMove.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __Configurable_h__
#include "Configurable.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

#ifndef __SpaceOrbEvent_h__
#include "SpaceOrbEvent.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __Action_h__
#include "Action.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __SelectionManager_h__
#include "SelectionManager.h"
#endif

#ifndef __TransformConfiguration_h__
#include "TransformConfiguration.h"
#endif

#ifndef __TypedFactory_h__
#include "TypedFactory.h"
#endif

#ifndef __CursorBallActionConfiguration_h__
#include "CursorBallActionConfiguration.h"
#endif

AnyOrbMove::AnyOrbMove ()
  : TypedFactory <CursorBallActionConfiguration, Action> ("AnyOrbMove")
{}

SP<CursorBallActionConfiguration> AnyOrbMove::typedDefaultConfiguration ()
  const
{
  return NEW (CursorBallActionConfiguration ());
}

String AnyOrbMove::getPrettyName (const Configuration *c) const {
  SP<const CursorBallActionConfiguration> cbtc =
    dynamic_cast <const CursorBallActionConfiguration *> (c);
  assert (cbtc);
  return "Use the Space Orb to "+cbtc->getTransformAction()->unParse();
}

SP<Action> AnyOrbMove::makeIt (CursorBallActionConfiguration *cbac) const {
  SP<Action> result = NEW (Action ());
  SP<TopLevel> top = cbac->getTopLevel ();
  SP<const SpaceOrbEvent> e =
    dynamic_cast <const SpaceOrbEvent *> (&*top->getEvent());
  assert (e);
  // We might just be bound to pointer motion.  In that case, don't grab.
  if (e->getButton () != e->pointerMotionButton () && cbac->isFirst ()) {
    SelectionManager::setSelectionBlink (false);
    // Nothing needs to move the first time.
    cbac->grabIfFirst (this);
  } else {
    if (cbac->isLast ()) {
      // We're about to lose the grab, start the selection blinking again.
      SelectionManager::setSelectionBlink (true);
    }
    // Pointedly "if" and not "else if" here, since if we're bound to a
    // pointerMotion event, the first time might be the last time (although I'd
    // have to read the code to know whether cbac->isLast () would be true in
    // that case.  In any case, I don't want the correctness of this code to
    // depend on that detail.) 
    if (e->getButton() == e->pointerMotionButton()) {
      SP<RecursiveSlotValue> rsv = cbac->getTransformAction ();
      SP<TransformConfiguration> tc =
	dynamic_cast <TransformConfiguration *>
	(&*rsv->getConfiguration());
      assert (tc);
      tc->setTopLevel (top);
      tc->parseOrbEvent (e);
      result = dynamic_cast <Action *> (&*rsv->makeIt ());
      assert (result);
    }
  }
  if (result->isProblem ()) {
    SelectionManager::setSelectionBlink (true);
  }
  return result;
}

namespace {
  static const bool useless =
  (FactoryTable::store ("SpaceOrbAction", NEW (AnyOrbMove ())),
   true);
}

SP<RecursiveSlotValue> AnyOrbMove::mkOrbMove (RecursiveSlotValue *slot) {
  SP<CursorBallActionConfiguration> cbtc =
    NEW (CursorBallActionConfiguration ());
  cbtc->setTransformAction (slot);
  SP<RecursiveSlotValue> rsv = NEW (RecursiveSlotValue ("SpaceOrbAction",
							"AnyOrbMove"));
  rsv->setConfiguration (&*cbtc);
  return rsv;
}

SP<RecursiveSlotValue> AnyOrbMove::mkOrbMove (const String &name) {
  return mkOrbMove (NEW (RecursiveSlotValue ("TransformAction", name)));
}
