// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __SubsetStorageConfiguration_h__
#define __SubsetStorageConfiguration_h__

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __SubsetStorage_h__
#include "SubsetStorage.h"
#endif

class RecursiveSlotValue;

class SubsetStorageConfiguration : public Configuration {
  SubsetStorage::Maintainer * m_maintainer;
  // The number of times that we went to move an object and found
  // that it had gone outside of its approximate bounding box. 
  int m_moved;
  // The number of times that we went to move an object and found that
  // it had not gone outside of its approximate bounding box.
  int m_notMoved;
public:
  SubsetStorageConfiguration ();
  SubsetStorageConfiguration (const SubsetStorageConfiguration &);
  // Tweak the next three so they updated and read m_moved and m_notMoved.
  SP<BadSlotValue> setSlot (const String &name, SP<SlotValue> sv);
  SP<const SlotValue> getSlot (const String &name) const;
  SP<SlotValue> getSlot (const String &name);
  SP<const RecursiveSlotValue> getIncrementalStorageSlot () const;
  SP<RecursiveSlotValue> getIncrementalStorageSlot ();
  void setIncrementalStorageSlot (SP<RecursiveSlotValue> rsv);
  SubsetStorage::Maintainer *getMaintainer () const;
  void setMaintainer (SubsetStorage::Maintainer *m);
  SP<Configuration> copy () const;
  bool hasTheSameTypeAs (const Configuration *c) const;
  inline void incMoved () {
    m_moved++;
  }
  inline void incNotMoved () {
    m_notMoved++;
  }
};

#endif
