// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#include "SubsetStorageConfiguration.h"

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __SubsetStorage_h__
#include "SubsetStorage.h"
#endif

#ifndef __IntSlotValue_h__
#include "IntSlotValue.h"
#endif

#ifndef __BadSlotValue_h__
#include "BadSlotValue.h"
#endif

#ifndef __SlotValue_h__
#include "SlotValue.h"
#endif

static String incrementalName () {
  return "Storage";
}

static String movedName () {
  return "Objects that moved outside their box";
}

static String notMovedName () {
  return "Objects that did not move outside their box";
}

SubsetStorageConfiguration::SubsetStorageConfiguration ()
  : m_moved (0), m_notMoved (0)
{
  initializeSlot (incrementalName (),
		  NEW (RecursiveSlotValue ("IncrementalStorage",
					   "ArrayStorage")));
  initializeSlot (movedName (), NEW (IntSlotValue (0)));
  initializeSlot (notMovedName (), NEW (IntSlotValue (0)));
  m_maintainer = 0;
}

SP<BadSlotValue> SubsetStorageConfiguration::setSlot
(const String &name, SP<SlotValue> sv) {
  if (movedName () == name) {
    IntSlotValue *pisv = dynamic_cast <IntSlotValue *> (&*sv);
    if (pisv) {
      m_moved = pisv->getValue();
      return 0;
    } else {
      return NEW (BadSlotValue ("an IntSlotValue"));
    }
  } else if (notMovedName () == name) {
    IntSlotValue *pisv = dynamic_cast <IntSlotValue *> (&*sv);
    if (pisv) {
      m_notMoved = pisv->getValue();
      return 0;
    } else {
      return NEW (BadSlotValue ("an IntSlotValue"));
    }
  } else {
    return Configuration::setSlot (name, sv);
  }
}

SP<const SlotValue> SubsetStorageConfiguration::getSlot (const String &name)
const
{
  if (movedName () == name) {
    return NEW (IntSlotValue (m_moved));
  } else if (notMovedName() == name) {
    return NEW (IntSlotValue (m_notMoved));
  } else {
    return Configuration::getSlot (name);
  }
}

SP<SlotValue> SubsetStorageConfiguration::getSlot (const String &name)
{
  if (movedName () == name) {
    return NEW (IntSlotValue (m_moved));
  } else if (notMovedName() == name) {
    return NEW (IntSlotValue (m_notMoved));
  } else {
    return Configuration::getSlot (name);
  }
}

SP<const RecursiveSlotValue>
SubsetStorageConfiguration::getIncrementalStorageSlot ()
  const
{
  return RecursiveSlotValue::getSlotValue (this, incrementalName());
}

SP<RecursiveSlotValue> SubsetStorageConfiguration::getIncrementalStorageSlot ()
{
  return RecursiveSlotValue::getSlotValue (SP<Configuration> (this),
					   incrementalName());
}

void SubsetStorageConfiguration::setIncrementalStorageSlot
(SP<RecursiveSlotValue> rsv)
{
  RecursiveSlotValue::setSlotValue (this, incrementalName(), rsv);
}

SubsetStorage::Maintainer *SubsetStorageConfiguration::getMaintainer () const {
  return m_maintainer;
}

void SubsetStorageConfiguration::setMaintainer (SubsetStorage::Maintainer *m) {
  m_maintainer = m;
}

SubsetStorageConfiguration::SubsetStorageConfiguration
(const SubsetStorageConfiguration &ssc)
  : Configuration (ssc), m_moved (0), m_notMoved (0)
{}

SP<Configuration> SubsetStorageConfiguration::copy () const {
  return NEW (SubsetStorageConfiguration (*this));
}

bool SubsetStorageConfiguration::hasTheSameTypeAs (const Configuration *c)
  const
{
  return 0 != dynamic_cast <const SubsetStorageConfiguration *> (c);
}
