// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifdef __StorageSceneConfiguration_h__
#warn Missing external include guard for StorageSceneConfiguration
#endif

#ifndef __StorageSceneConfiguration_h__
#define __StorageSceneConfiguration_h__

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __SceneGraphConfiguration_h__
#include "SceneGraphConfiguration.h"
#endif

#ifndef __BadSlotValue_h__
#include "BadSlotValue.h"
#endif

class StorageSceneConfiguration : public SceneGraphConfiguration {
  const String m_slotName;
public:
  StorageSceneConfiguration ()
    : m_slotName ("Storage Factory")
  {
    initializeSlot (m_slotName,
		    NEW (RecursiveSlotValue
			 (FactoryTable::load ("Storage", "ArrayStorage"))));
  }
  void setStorageFactory (Factory *f) {
    SP<BadSlotValue> b = setSlot (m_slotName, NEW (RecursiveSlotValue (f)));
    assert (!b);
  }
  Factory *getStorageFactory () const {
    SP<RecursiveSlotValue> slot =
      dynamic_cast <RecursiveSlotValue *> (getSlot (m_slotName));
    assert (slot);
    return slot->getFactory ();
  }
  Configuration *getStorageConfiguration () const {
    SP<RecursiveSlotValue> slot =
      dynamic_cast <RecursiveSlotValue *> (getSlot (m_slotName));
    assert (slot);
    return slot->getConfiguration ();
  }
  SP<Configuration> copy () const {
    return NEW (StorageSceneConfiguration (*this));
  }
  bool hasTheSameTypeAs (const Configuration *c) const {
    return 0 != dynamic_cast <const StorageSceneConfiguration *> (c);
  }
};

#endif
