// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Storage_h__
#define __Storage_h__

class BoundingBox;

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __Refcount_h__
#include "Refcount.h"
#endif

#ifndef __Configurable_h__
#include "Configurable.h"
#endif

// A class that can store particles and then lookup nearby particles 
class Storage : public Configurable {
 public:
  virtual ~Storage () {};
  // Record that a particle with the given index has the given bounding box.
  // Returns true if the object could be stored.  Returns false if the
  // caller needs to delete the object because it is outside the
  // boundary that the storage can deal with.
  // You aren't allowed to store the same index twice unless you call
  // "empty" inbetween.
  virtual bool store (int value, const BoundingBox &box) = 0;
  // Fetch all indices that overlap the given bounding box.  Eliminate
  // duplicates, and while we're at it eliminate the element notThis.
  // The first thing fetch should do is extend result to 0.
  virtual void fetch (const BoundingBox &box, int notThis,
		      Dynavec <int> &result) const = 0;
  // Empty it out.
  virtual void empty () = 0;
};
#endif
