// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Storage_h__
#include "Storage.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __BoundingBox_h__
#include "BoundingBox.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __SimpleConfiguration_h__
#include "SimpleConfiguration.h"
#endif

namespace {

class SimpleStorage: public Storage {
  // Everybody is everybody's neighbor.
  Dynavec <int> m_everybody;
 public:
  bool store (int value, const BoundingBox &box);
  void fetch (const BoundingBox &box, int notThis, Dynavec <int> &result)
    const;
  void empty ();
};

bool SimpleStorage::store (const int value, const BoundingBox &box) {
  (void) box; // Suppress warning.
#ifndef NDEBUG
  // Enforce the restriction that you can't store the same value twice
  // without calling empty inbetween.
  for (int i = 0; i < m_everybody.size(); i++) {
    assert (value != m_everybody[i]);
  }
#endif
  m_everybody.push (value);
  return true;
}

void SimpleStorage::fetch (const BoundingBox &box,
			   const int notThis,
			   Dynavec <int> &result) const {
  (void) box; // Suppress warning
  result.extendTo (0);
  for (int i = 0; i < m_everybody.size(); i++) {
    int next = m_everybody [i];
    if (notThis != next) {
      result.push (next);
    }
  }
}

void SimpleStorage::empty () {
  m_everybody.extendTo (0);
}

class SimpleStorageFactory : public Factory {
public:
  SimpleStorageFactory () : Factory ("SimpleStorage") {}
  SP<Configuration> defaultConfiguration () const {
    return NEW (SimpleConfiguration ());
  }
  SP<Configurable> makeIt (const SP<Configuration> c) const {
    (void) c;
    return NEW (SimpleStorage ());
  }
};

static const bool useless2 =
(FactoryTable::store ("Storage", NEW (SimpleStorageFactory ())),
 true);

} // namespace
