// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#include "SceneLoaderConfiguration.h"

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __Vec3SlotValue_h__
#include "Vec3SlotValue.h"
#endif

#ifndef __BadSlotValue_h__
#include "BadSlotValue.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __BoolSlotValue_h__
#include "BoolSlotValue.h"
#endif

namespace {
  const String whereName () {
    return "Where to put it";
  }
  String selectName () {
    return "Select objects added to scene";
  }
}

SceneLoaderConfiguration::SceneLoaderConfiguration () {
  initializeSlot (whereName (), NEW (Vec3SlotValue (Vec3 (0, 0, 0))));
  initializeSlot (selectName (), NEW (BoolSlotValue (true)));
}

bool SceneLoaderConfiguration::getSelect () const {
  return BoolSlotValue::getSlot (this, selectName());
}

void SceneLoaderConfiguration::setSelect (bool select) {
  BoolSlotValue::setSlot (this, selectName(), select);
}

Vec3 SceneLoaderConfiguration::getWhere () const {
  SP<const SlotValue> slot = getSlot (whereName ());
  const Vec3SlotValue *v3sv = dynamic_cast <const Vec3SlotValue *> (&*slot);
  assert (v3sv);
  return v3sv->getValue();
}

void SceneLoaderConfiguration::setWhere (const Vec3 &v) {
  SP<BadSlotValue> b = setSlot (whereName (), NEW (Vec3SlotValue (v)));
  assert (!b);
}

SceneLoaderConfiguration::SceneLoaderConfiguration
(const SceneLoaderConfiguration &slc)
  : ActionConfiguration (slc)
{}

SP<Configuration> SceneLoaderConfiguration::copy () const {
  return NEW (SceneLoaderConfiguration (*this));
}

SceneLoaderConfiguration &SceneLoaderConfiguration::operator=
(const SceneLoaderConfiguration &conf)
{
  if (this != &conf) {
    ActionConfiguration::operator= (conf);
    setSelect (conf.getSelect ());
    setWhere (conf.getWhere ());
  }
  return *this;
}

bool SceneLoaderConfiguration::hasTheSameTypeAs (const Configuration *c)
  const
{
  return 0 != dynamic_cast <const SceneLoaderConfiguration *> (c);
}
