// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifdef __SceneGraphConfiguration_h__
#warn Missing external include guard for SceneGraphConfiguration
#endif

#ifndef __SceneGraphConfiguration_h__
#define __SceneGraphConfiguration_h__

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

class SceneGraph;

class SceneGraphConfiguration
  : public Configuration
{
  struct SceneGraphConfigurationData;
  SceneGraphConfigurationData *m_data;
 public:
  SceneGraphConfiguration ();
  SceneGraphConfiguration (const SceneGraphConfiguration &sgc);
  virtual ~SceneGraphConfiguration ();
  // If you want the new scene graph to start its work by copying data
  // from an old scene graph, use setSceneGraph on the configuration
  // before making it.
  // And then if you plan to keep this configuration around, be sure
  // to call setSceneGraph (0) so the old one will be deleted.
  void setSceneGraph (SceneGraph *g);
  SceneGraph *getSceneGraph () const;
  SP<Configuration> copy () const;
  bool hasTheSameTypeAs (const Configuration *c) const;
};
#endif
