// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#include "SceneGraphConfiguration.h"

#ifndef __SceneGraph_h__
#include "SceneGraph.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

struct SceneGraphConfiguration::SceneGraphConfigurationData {
  SP<SceneGraph> m_graph;
};

SceneGraphConfiguration::SceneGraphConfiguration ()
  : m_data (NEW (SceneGraphConfigurationData ()))
{}

SceneGraphConfiguration::~SceneGraphConfiguration () {
  delete m_data;
  m_data = 0;
}

void SceneGraphConfiguration::setSceneGraph (SceneGraph *g) {
  m_data->m_graph = g;
}

SceneGraph *SceneGraphConfiguration::getSceneGraph () const {
  return m_data->m_graph;
}

SceneGraphConfiguration::SceneGraphConfiguration
(const SceneGraphConfiguration &sgc)
  : Configuration (sgc),
    m_data (NEW (SceneGraphConfigurationData (*sgc.m_data)))
{}

SP<Configuration> SceneGraphConfiguration::copy () const {
  return NEW (SceneGraphConfiguration (*this));
}

bool SceneGraphConfiguration::hasTheSameTypeAs (const Configuration *c)
  const
{
  return 0 != dynamic_cast <const SceneGraphConfiguration *> (c);
}
