// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifdef __IncrementalStorageSceneConfiguration_h__
#warn Missing external include guard for IncrementalStorageSceneConfiguration
#endif

#ifndef __IncrementalStorageSceneConfiguration_h__
#define __IncrementalStorageSceneConfiguration_h__

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __RecursiveSlotValue_h__
#include "RecursiveSlotValue.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __SceneGraphConfiguration_h__
#include "SceneGraphConfiguration.h"
#endif

#ifndef __BadSlotValue_h__
#include "BadSlotValue.h"
#endif

class IncrementalStorageSceneConfiguration : public SceneGraphConfiguration {
  const String m_slotName;
public:
  IncrementalStorageSceneConfiguration ()
    : m_slotName ("Incremental Storage Factory")
  {
    initializeSlot (m_slotName,
		    NEW (RecursiveSlotValue
			 (FactoryTable::load ("IncrementalStorage",
					      "ArrayStorage"))));
  }
  void setIncrementalStorageFactory (Factory *f) {
    SP<BadSlotValue> b = setSlot (m_slotName, NEW (RecursiveSlotValue (f)));
    assert (!b);
  }
  Factory *getIncrementalStorageFactory () const {
    SP<RecursiveSlotValue> slot =
      dynamic_cast <RecursiveSlotValue *> (getSlot (m_slotName));
    assert (slot);
    return slot->getFactory ();
  }
  Configuration *getIncrementalStorageConfiguration () const {
    SP<RecursiveSlotValue> slot =
      dynamic_cast <RecursiveSlotValue *> (getSlot (m_slotName));
    assert (slot);
    return slot->getConfiguration ();
  }
  SP<Configuration> copy () const;
  bool hasTheSameTypeAs (const Configuration *c) const;
};

#endif
