// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifdef __IncrementalStorage_h__
#warn Missing external include guard for IncrementalStorage
#endif

#ifndef __IncrementalStorage_h__
#define __IncrementalStorage_h__

#ifndef __Storage_h__
#include "Storage.h"
#endif

class IncrementalStorage : public Storage {
 public:
  virtual ~IncrementalStorage () {};
  
  // Like Storage::store, except you get back a BoundingBox that will
  // be a superset of the the given BoundingBox.  We actually recorded
  // that the object is in the larger BoundingBox, so if the object
  // has not moved outside of that box, there is no need to update the
  // storage.
  virtual bool store (int value, const BoundingBox &box,
		      BoundingBox &includedBox) = 0;
  // FIXME Add storeAndFetch
  // Could be more efficient than store followed by fetch.  For
  // ArrayStorage, we could collapse the two triple-loops for store
  // and for fetch.
  // FIXME Add move
  // Like remove and store and fetch all together.  Merge all three
  // triple loops.  Don't need to remove the object from places where
  // it will still be after the move; can return separately the neighbors
  // it no longer has and its new neighbors.  First do the add, meanwhile
  // setting some flags, and then when doing the remove we can ignore
  // places where the flag is set, then clear the flags.  While
  // setting the flags, accumulate a Dynavec <bool *> so we can
  // efficiently clear the flags.  The debug implementation does a
  // fetch, remove, store, fetch, then removes and re-adds it at the
  // old location, then does the move, then compares expected to
  // actual results.

  // Delete the value from the storage.  The given box should be the
  // box that was given as the "box" parameter to store when it was
  // originally called.  (We don't want includedBox because roundoff
  // error might make the boxes not line up right, and because we want
  // to be able to delete the object if it was stored with the two
  // parameter version of store.)
  //
  // Beware -- if an attempt was made to store the object, and the
  // attempt returned "false" because the object was out of bounds,
  // then it is not valid to delete the object.
  virtual void remove (int value, const BoundingBox &box) = 0;
  
};

#endif
