// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __StringSlotValue_h__
#include "StringSlotValue.h"
#endif

#ifndef __FileSceneLoaderConfiguration_h__
#include "FileSceneLoaderConfiguration.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

namespace {
  String fileNameName () {
    return "File name";
  }
}

String FileSceneLoaderConfiguration::getFileName () const {
  return StringSlotValue::getSlot (this, fileNameName());
}

void FileSceneLoaderConfiguration::setFileName (const String &s) {
  StringSlotValue::setSlot (this, fileNameName (), s);
}

FileSceneLoaderConfiguration::FileSceneLoaderConfiguration ()
{
  initializeSlot (fileNameName (),
		  NEW (StringSlotValue ("Unspecified file name")));
};

SP<Configuration> FileSceneLoaderConfiguration::copy () const {
  return NEW (FileSceneLoaderConfiguration (*this));
}

// Copy all fields from the given configuration into ourselves.
FileSceneLoaderConfiguration &FileSceneLoaderConfiguration::operator=
(const FileSceneLoaderConfiguration &conf)
{
  if (&conf != this) {
    SceneLoaderConfiguration::operator= (conf);
    setFileName (conf.getFileName ());
  }
  return *this;
}

bool FileSceneLoaderConfiguration::hasTheSameTypeAs (const Configuration *c)
  const
{
  return 0 != dynamic_cast <const FileSceneLoaderConfiguration *> (c);
}

