// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __CharacteristicSizeConfiguration_h__
#define __CharacteristicSizeConfiguration_h__

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __FloatSlotValue_h__
#include "FloatSlotValue.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

class SlotException;

#ifndef __BadSlotValue_h__
#include "BadSlotValue.h"
#endif

#ifndef __PositiveFloatSlotValue_h__
#include "PositiveFloatSlotValue.h"
#endif

class CharacteristicSizeConfiguration : public Configuration {
  const String m_slotName;
public:
  CharacteristicSizeConfiguration ()
    : m_slotName ("Characteristic Size")
  {
    initializeSlot (m_slotName, NEW (PositiveFloatSlotValue (2.0)));
  }
  void setCharacteristicSize (Float f) {
    SP<BadSlotValue> b = setSlot (m_slotName, NEW (FloatSlotValue (f)));
    assert (!b);
  }
  Float getCharacteristicSize () const {
    SP<const FloatSlotValue> slot =
      dynamic_cast <const FloatSlotValue *> (&*getSlot (m_slotName));
    assert (slot);
    return slot->getValue ();
  }
  SP<Configuration> copy () const {
    return NEW (CharacteristicSizeConfiguration (*this)); 
  }
  bool hasTheSameTypeAs (const Configuration *c) const {
    return 0 != dynamic_cast <const CharacteristicSizeConfiguration *> (c);
  }
};

#endif
