// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __ArrayStorageConfiguration_h__
#define __ArrayStorageConfiguration_h__

#ifndef __CharacteristicSizeConfiguration_h__
#include "CharacteristicSizeConfiguration.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __BadSlotValue_h__
#include "BadSlotValue.h"
#endif

#ifndef __PositiveIntSlotValue_h__
#include "PositiveIntSlotValue.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __SlotValue_h__
#include "SlotValue.h"
#endif

#ifndef __IntSlotValue_h__
#include "IntSlotValue.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

class ArrayStorageConfiguration : public CharacteristicSizeConfiguration
{
  String m_sizeName;
 public:
  ArrayStorageConfiguration (int size =
			     // If the size is 128, the array consumes
			     // 128 x 128 x 128 x 4 = 8MB 
			     // of memory. 
			     128
			     )
    : m_sizeName ("Array Size")
    {
      assert (size > 0);
      initializeSlot (m_sizeName, NEW (PositiveIntSlotValue (size)));
    }
  ArrayStorageConfiguration (const ArrayStorageConfiguration &a)
    : CharacteristicSizeConfiguration (a),
      m_sizeName (a.m_sizeName)
  {}
  void setArraySize (int s) {
    PositiveIntSlotValue::setSlot (this, m_sizeName, s);
  }
  int getArraySize () const {
    return PositiveIntSlotValue::getSlot (this, m_sizeName);
  }
  SP<Configuration> copy () const {
    return NEW (ArrayStorageConfiguration (*this));
  }
  bool hasTheSameTypeAs (const Configuration *c) const {
    return 0 != dynamic_cast <const ArrayStorageConfiguration *> (c);
  }

};

#endif
