// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __ActionConfiguration_h__
#define __ActionConfiguration_h__

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

class TopLevel;

// What we need to know to perform some action, probably specified by
// the user.  There will be general-purpose code to let the user fill
// in the fields of the Configuration, so this base class doesn't have
// any fields for the user to fill in.  Otherwise the subclasses of
// this class would be stuck with junk in their UI that they can't get rid of.
class ActionConfiguration
  : public Configuration
{
  struct ActionConfigurationData;
  ActionConfigurationData *m_data;
public:
  ActionConfiguration ();
  ActionConfiguration (const ActionConfiguration &ac);
  ~ActionConfiguration ();
  SP<Configuration> copy () const;
  ActionConfiguration &operator= (const ActionConfiguration &conf);
  bool hasTheSameTypeAs (const Configuration *c) const;

  // There is no real danger that the TopLevel will go away in the middle of an
  // action, and having a smart pointer to a TopLevel here tends to create
  // reference cycles because the TopLevel has references to
  // ActionConfigurations and vice versa.  So just have a normal pointer
  // instead.
  void setTopLevel (TopLevel *toplevel);
  // Used to have two getTopLevel's, one const method returning a const
  // TopLevel *, and one non-const method returning a non-const TopLevel *.
  // But that prevents us from writing a reasonable assignment operator, since
  // that assignment operator should get a const ActionConfiguration, and then
  // the old scheme would only allow it to have a const TopLevel, which we
  // can't put into a non-const *this in an assignment operator.  Thus we need
  // getTopLevel to be const but return a non-const TopLevel.
  TopLevel *getTopLevel () const;
};
#endif
