// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __ActionConfiguration_h__
#include "ActionConfiguration.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __TopLevel_h__
#include "TopLevel.h"
#endif

class ActionConfiguration::ActionConfigurationData {
public:
  TopLevel *m_toplevel;
  ActionConfigurationData ()
    // Initialize to null for deterministic bugs.
    : m_toplevel (0)
  {}
};

ActionConfiguration::ActionConfiguration ()
  : m_data (NEW (ActionConfigurationData))
{}

ActionConfiguration::ActionConfiguration (const ActionConfiguration &ac)
  : Configuration (ac),
    m_data (NEW (ActionConfigurationData))
{
  *m_data = *(ac.m_data);
}

ActionConfiguration::~ActionConfiguration ()
{
  assert (m_data);
  delete m_data;
  m_data = 0;
}

void ActionConfiguration::setTopLevel (TopLevel *toplevel) {
  m_data->m_toplevel = toplevel;
}

TopLevel *ActionConfiguration::getTopLevel () const {
  return m_data->m_toplevel;
}

SP<Configuration> ActionConfiguration::copy () const {
  return NEW (ActionConfiguration (*this));
}

ActionConfiguration &ActionConfiguration::operator=
(const ActionConfiguration &conf)
{
  if (this != &conf) {
    setTopLevel (conf.getTopLevel ());
  }
  return *this;
}

bool ActionConfiguration::hasTheSameTypeAs (const Configuration *c)
  const
{
  return 0 != dynamic_cast <const ActionConfiguration *> (c);
}
