// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Action_h__
#define __Action_h__

#ifndef __Configurable_h__
#include "Configurable.h"
#endif

class String;

// Running a factory to make one of these performs some action.
// Everything we need to know so we can do the action is built into
// the ActionConfiguration.  Any error information goes into the
// Action object.  We don't use exception handling because compiling
// with exception handling turned on slows down the entire program,
// and we are most indubitably compute-bound.
class Action
  : public Configurable
{
  // Hide the real state information behind a pointer, so we can make
  // binary-compatible upgrades later.
  class ActionData;
  ActionData *m_data;
public:
  Action ();
  // A subclass should call this to say that a problem happened and
  // give an error message.  It is permitted to call setProblem more than once.
  // The last problem noted is the one that is reported to the user.
  //
  // The Gnu Emacs convention for messages to the user is that they start with
  // a capital letter and do not have a period at the end.  Let's do the same.
  virtual void setProblem (const String &s);
  virtual ~Action ();
  // Whether the command got an error.
  virtual bool isProblem () const;
  // An error message from the command.  If you give an empty error
  // message to setProblem, getProblem will return something more
  // user-friendly than what you gave to setProblem.
  virtual String getProblem () const;
  // Whether there is a non-error message to report.
  virtual bool isMessage () const;
  virtual void setMessage (const String &s);
  virtual String getMessage () const;
};
#endif
