// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#include "Action.h"

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

class Action::ActionData {
public:
  String m_problem;
  String m_message;
};

Action::Action () {
  m_data = NEW (ActionData ());
}

Action::~Action () {
  assert (m_data);
  delete m_data;
  m_data = 0;
}

bool Action::isProblem () const {
  return m_data->m_problem.size() > 0;
}

String Action::getProblem () const {
  return m_data->m_problem;
}

void Action::setProblem (const String &s) {
  if (s == "") {
    m_data->m_problem = "Empty error message given";
  } else {
    m_data->m_problem = s;
  }
}

bool Action::isMessage () const {
  return m_data->m_message.size() > 0;
}

String Action::getMessage () const {
  return m_data->m_message;
}

void Action::setMessage (const String &s) {
  if (s == "") {
    m_data->m_message = "Empty error message given";
  } else {
    m_data->m_message = s;
  }
}

