// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __TheObjectDrawerFactory_h__
#define __TheObjectDrawerFactory_h__

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

class String;
class ObjectDrawerConnection;
class ConstantRecursiveSlotValue;

// Encapsulates a global variable representing the current ObjectDrawerFactory
// and other global information, such as the list of classes that need
// ObjectDrawers and (eventually) the list of PhysicsObjects that have
// object drawers so we can revise them when we change window systems
// on the fly.
class TheObjectDrawerFactory
{
  friend class ObjectDrawerConnection;
  static void giveObjectDrawer (SP<ObjectDrawerConnection> odconn);
  // Allow ObjectDrawerConnection's to register themselves, so we can
  // update them when setTheObjectDrawerFactory is called.
  static void registerConnection (SP<ObjectDrawerConnection> odc);
  // This should be called in the destructor for
  // ObjectDrawerConnection.
  static void deRegisterConnection (SP<ObjectDrawerConnection> odc);
public:
  // Switching window systems should be done by closing the old window
  // system, opening the new window system, and then calling
  // setTheObjectDrawerFactory with a ConstantRecursiveSlotValue that
  // generates ObjectDrawers (so it had better have an
  // ObjectDrawerConfiguration as its configuration).
  // If we try to draw anything when the wrong window
  // system is open, we'll lose.
  static void setTheObjectDrawerFactory (SP<ConstantRecursiveSlotValue> odf);
  // I can't imagine a reason that anyone would want to get the
  // current object drawer factory.  It's available by following a few
  // pointers from the TopConfiguration, anyway.
  // static SP<ConstantRecursiveSlotValue> getTheObjectDrawerfactory ();

  // The Ball class should call this with the string "Ball" before
  // main starts.  Nobody is allowed to make a PhysicsObject until
  // after this has been called by all drawing classes.
  static void registerObjectDrawer (const String &className);
  // Return a list of classes for which registerObjectDrawer has been
  // called.  The configuration for ObjectDrawerFactoryFactory needs
  // to know this list so it can have a slot for each in its
  // defaultConfiguration.
  static Dynavec <String> allRegisteredObjectDrawers ();
};


#endif
