// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#include "PhysicsObject.h"

#ifndef __Float_h__
#include "Float.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __BoundingSphere_h__
#include "BoundingSphere.h"
#endif

#ifndef __BoundingBox_h__
#include "BoundingBox.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

PhysicsObject::PhysicsObject (const String &objectDrawerClass,
			      SP<Configuration> conf)
  : ObjectDrawerConnection (objectDrawerClass, conf)
{
}

static inline Float square (Float val) {
  return val * val;
}

BoundingSphere PhysicsObject::physicsBoundingSphere (const Float *state) const
{
  return BoundingSphere (physicsBoundingSphereRadius(),
			 boundingSphereCenter (state));
}

BoundingBox PhysicsObject::physicsBoundingBox (const Float *state) const {
  return BoundingBox (physicsBoundingSphere (state));
}

void PhysicsObject::doPhysics (const Float *state, 
			       Float *deriv,
			       int myIndex,
			       const Dynavec<PhysicsObjectInfo> &neighbors)
  const
{
  // Suppress warnings.
  (void) state; (void) deriv; (void) myIndex; (void) neighbors;
  // Does nothing.
  return;
}

void PhysicsObject::doPhysics (const Float *state, 
			       Float *deriv,
			       int myIndex,
			       const Dynavec<PhysicsObjectInfo> &neighbors,
			       const Dynavec<PhysicsObjectInfo> &links)
  const
{
  (void) links;
  doPhysics (state, deriv, myIndex, neighbors);
  return;
}

void PhysicsObject::translate (Dynavec <Float> &state, const Vec3 &v) const {
  assert (state.size() == stateSize());
  translate (&(state[0]), v);
}

bool PhysicsObject::hasAnimationEver () const {
  return false;
}

bool PhysicsObject::hasAnimationNow (const SceneGraph *sg, int index) const {
  (void) sg; (void) index;
  return false;
}

void PhysicsObject::animateTimeStep (SceneGraph *sg, int index) const {
  (void) sg; (void) index;
}

void PhysicsObject::animateFrame (Canvas *canvas, SceneGraph *sg, int index)
  const
{
  (void) canvas; (void) sg; (void) index;
}

bool PhysicsObject::isSelectable () const {
  return true;
}

bool PhysicsObject::isRelevantNeighbor (const PhysicsObject *o, int myIndex,
					int neighborIndex) const
{
  (void) o;
  (void) myIndex;
  (void) neighborIndex;
  return true;
}
