// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __OneObjectDrawerConfiguration_h__
#include "OneObjectDrawerConfiguration.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

struct OneObjectDrawerConfiguration::OneObjectDrawerConfigurationData {
  SP<Configuration> m_poc;
};

OneObjectDrawerConfiguration::OneObjectDrawerConfiguration ()
: m_data (NEW (OneObjectDrawerConfigurationData ()))
{}

OneObjectDrawerConfiguration::~OneObjectDrawerConfiguration ()
{
  assert (m_data);
  delete m_data;
  m_data = 0;
}

SP<Configuration> OneObjectDrawerConfiguration::getPhysicsObjectConfiguration
()
{
  return m_data->m_poc;
}

SP<const Configuration> OneObjectDrawerConfiguration::getPhysicsObjectConfiguration () const {
  return &* m_data->m_poc;
}

void OneObjectDrawerConfiguration::setPhysicsObjectConfiguration (SP<Configuration> conf) {
  m_data->m_poc = conf;
}

OneObjectDrawerConfiguration::OneObjectDrawerConfiguration
(const OneObjectDrawerConfiguration &oodc)
  : Configuration (oodc),
    m_data (NEW (OneObjectDrawerConfigurationData ()))
{
  if (oodc.m_data->m_poc) {
    m_data->m_poc = oodc.m_data->m_poc->copy ();
  } else {
    m_data->m_poc = 0;
  }
}

SP<Configuration> OneObjectDrawerConfiguration::copy () const {
  return NEW (OneObjectDrawerConfiguration (*this));
}

bool OneObjectDrawerConfiguration::hasTheSameTypeAs
(const Configuration *c) const
{
  return 0 != dynamic_cast <const OneObjectDrawerConfiguration *> (c);
}
