// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __ObjectDrawerConnection_h__
#define __ObjectDrawerConnection_h__

#ifndef __Refcount_h__
#include "Refcount.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __ObjectDrawer_h__
#include "ObjectDrawer.h"
#endif

class Configuration;
class String;
class ObjectDrawer;

class ObjectDrawerConnection
  : public virtual Refcount
{
  // Next one isn't part of Data so we can have the inline below.
  SP<ObjectDrawer> m_objectDrawer;
  struct ObjectDrawerConnectionData;
  ObjectDrawerConnectionData *m_data;
  friend class TheObjectDrawerFactory;
  void setObjectDrawer (SP<ObjectDrawer> od);
  // ObjectDrawerConnections need to register with TheObjectDrawerFactory, so
  // we can implement changing window systems on the fly.
  // TheObjectDrawerFactory has a vector of ObjectDrawerConnections.  So we can
  // deregister ourselves later, we allow TheObjectDrawerFactory to tell us our
  // position in the vector.
  // In retrospect, this operation has no need to be fast, so it would be
  // better to just sequentially search the vector and get rid of the next
  // two methods and the associated state.  But there isn't much benefit from
  // deleteing the complexity and re-debugging, either.
  void setObjectDrawerPosition (int position);
  int getObjectDrawerPosition () const;
  SP<Configuration> getConfiguration ();
public:
  // Takes as arguments the class name to use when generating the ObjectDrawer,
  // and the PhysicsObject configuration to incorporate into the ObjectDrawer's
  // configuration.  For instance, odc is "Ball" when creating a Ball, and this
  // string has stuff concatenated to the beginning and the end to find the
  // factory name "XBallDrawer" or "OGLBallDrawer" or whatever.
  ObjectDrawerConnection (const String &odc, SP<Configuration> conf);
  virtual ~ObjectDrawerConnection ();
  String getObjectDrawingClass () const;
  const ObjectDrawer *getObjectDrawer () const;
  ObjectDrawer *getObjectDrawer ();
};

#endif
