// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __ObjectDrawerConfiguration_h__
#define __ObjectDrawerConfiguration_h__

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

class String;

class ObjectDrawerConfiguration
 : public Configuration
{
  struct ObjectDrawerConfigurationData;
  ObjectDrawerConfigurationData *m_data;
public:
  // Set the configuration of the underlying PhysicsObject.
  // We have to know the configuration of the underlying PhysicsObject because
  // when we create the ObjectDrawer, the ObjectDrawer may need to know that
  // configuration too.  For example, the material and radius of a Ball are
  // stored in the configuration of the PhysicsObject, and we obviously need to
  // know those to draw the Ball.
  SP<Configuration> getPhysicsObjectConfiguration ();
  SP<const Configuration> getPhysicsObjectConfiguration () const;
  void setPhysicsObjectConfiguration (SP<Configuration> conf);

  // The className is Ball, Disk, whatever.
  String getClassName ();
  void setClassName (const String &s);

  // If you pass in a window system name, then it makes a bunch of
  // editable slots that list the ObjectDrawers for each registered
  // drawer, a la TheObjectDrawerFactory.  You have one of these built
  // into each TopLevelConfiguration.
  ObjectDrawerConfiguration (const String &windowSystem);
  ~ObjectDrawerConfiguration ();
  ObjectDrawerConfiguration (const ObjectDrawerConfiguration &odc);
  SP<Configuration> copy () const;
  bool hasTheSameTypeAs (const Configuration *c) const;
};

#endif
