// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __ObjectDrawerConfiguration_h__
#include "ObjectDrawerConfiguration.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __ConstantRecursiveSlotValue_h__
#include "ConstantRecursiveSlotValue.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __TheObjectDrawerFactory_h__
#include "TheObjectDrawerFactory.h"
#endif

struct ObjectDrawerConfiguration::ObjectDrawerConfigurationData {
  SP<Configuration> m_physicsObjectConfiguration;
  String m_className;
  String m_windowSystem;
  ObjectDrawerConfigurationData (const ObjectDrawerConfigurationData &odc)
    : m_physicsObjectConfiguration (odc.m_physicsObjectConfiguration->copy ()),
      m_className (odc.m_className),
      m_windowSystem (odc.m_windowSystem)
  {}
  ObjectDrawerConfigurationData () {}
};

ObjectDrawerConfiguration::ObjectDrawerConfiguration
(const String &windowSystem)
  : m_data (NEW (ObjectDrawerConfigurationData ()))
{
  m_data->m_windowSystem = windowSystem;
  Dynavec <String> allods =
    TheObjectDrawerFactory::allRegisteredObjectDrawers ();
  for (int i = 0; i < allods.size(); i++) {
    initializeSlot (allods[i], NEW (ConstantRecursiveSlotValue
				    ("ObjectDrawer",
				     // The factory name might be
				     // "OGLBallDrawer", for example.
				     windowSystem+allods[i]+"Drawer")));
  }
}

ObjectDrawerConfiguration::~ObjectDrawerConfiguration ()
{
  assert (m_data);
  delete m_data;
  m_data = 0;
}

SP<Configuration>
ObjectDrawerConfiguration::getPhysicsObjectConfiguration () {
  return m_data->m_physicsObjectConfiguration;
}

SP<const Configuration>
ObjectDrawerConfiguration::getPhysicsObjectConfiguration () const {
  return &*m_data->m_physicsObjectConfiguration;
}

void
ObjectDrawerConfiguration::setPhysicsObjectConfiguration
(SP<Configuration> conf)
{
  m_data->m_physicsObjectConfiguration = conf;
}

String ObjectDrawerConfiguration::getClassName () {
  return m_data->m_className;
}

void ObjectDrawerConfiguration::setClassName (const String &s) {
  // You should only set the class name to a registered class name.
  assert (getSlot (s));
  m_data->m_className = s;
}

ObjectDrawerConfiguration::ObjectDrawerConfiguration
(const ObjectDrawerConfiguration &odc)
  : Configuration (odc),
    m_data (NEW (ObjectDrawerConfigurationData (*odc.m_data)))
{}

SP<Configuration> ObjectDrawerConfiguration::copy () const
{
  return NEW (ObjectDrawerConfiguration (*this));
}

bool ObjectDrawerConfiguration::hasTheSameTypeAs (const Configuration *c)
  const
{
  return 0 != dynamic_cast <const ObjectDrawerConfiguration *> (c);
}


