// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __NullObjectDrawer_h__
#define __NullObjectDrawer_h__

#ifndef __ObjectDrawer_h__
#include "ObjectDrawer.h"
#endif

class String;
class NullObjectDrawer
// An object drawer that does nothing, except optionally print a
// message to stdout the first time it is used.
  : public ObjectDrawer
{
  struct NullObjectDrawerData;
  NullObjectDrawerData *m_data;
public:
  // This version quietly does nothing.
  NullObjectDrawer ();
  ~NullObjectDrawer ();
  // This version prints a message "Stub object drawer for <name>" the
  // first time any of its methods are called.
  NullObjectDrawer (const String &name);

  bool intersect (const Float *state,
		  const Vec3 &v1, const Vec3 &v2, Vec3 *result) const;
  bool graphicsIntersect (const Float *state, const BoundingBox &box)
    const;
  bool intersect (const Float *state,
		  const Vec3 &v) const;
  Float graphicsBoundingSphereRadius () const;
  void draw (const Float *state, const Canvas *vo) const;
  void draw (const Float *state, const Canvas *vo,
	     // The index of me into the state array.
	     int myIndex,
	     const Dynavec<PhysicsObjectInfo> &neighbors) const;
  Vec3 boundingSphereCenter (const Float *state) const;
};
#endif
