// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __NullObjectDrawer_h__
#include "NullObjectDrawer.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __BoundingBox_h__
#include "BoundingBox.h"
#endif

struct NullObjectDrawer::NullObjectDrawerData {
  bool m_mumbled;
  String m_name;
  void yelp () {
    if (! m_mumbled) {
      m_mumbled = true;
      message (String ("Stub object drawer for ") + m_name + " invoked");
    }
  }
};

NullObjectDrawer::NullObjectDrawer ()
  : m_data (NEW (NullObjectDrawerData ()))
{
  m_data->m_mumbled = true;
}

NullObjectDrawer::NullObjectDrawer (const String &name)
  : m_data (NEW (NullObjectDrawerData ()))
{
  m_data->m_mumbled = false;
  m_data->m_name = name;
}

NullObjectDrawer::~NullObjectDrawer () {
  assert (m_data);
  delete m_data;
  m_data = 0;
}

bool NullObjectDrawer::intersect (const Float *state,
		const Vec3 &v1, const Vec3 &v2, Vec3 *result) const
{
  (void) state; (void) v1; (void) v2; (void) result;
  m_data->yelp ();
  return false;
}

bool NullObjectDrawer::graphicsIntersect (const Float *state, const BoundingBox &box)
  const {
  (void) state; (void) box;
  m_data->yelp ();
  return false;
}

bool NullObjectDrawer::intersect (const Float *state, const Vec3 &v) const {
  (void) state; (void) v;
  m_data->yelp ();
  return false;
}

Float NullObjectDrawer::graphicsBoundingSphereRadius () const {
  m_data->yelp ();
  return 0;
}

void NullObjectDrawer::draw (const Float *state, const Canvas *vo) const {
  (void) state; (void) vo;
  m_data->yelp ();
}

void NullObjectDrawer::draw (const Float *state, const Canvas *vo,
	   int myIndex,
	   const Dynavec<PhysicsObjectInfo> &neighbors) const {
  (void) state; (void) vo; (void) myIndex; (void) neighbors;
  m_data->yelp ();
}

Vec3 NullObjectDrawer::boundingSphereCenter (const Float *state) const {
  (void) state;
  m_data->yelp ();
  return Vec3 (0,0,0);
}
