// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __NullObject_h__
#define __NullObject_h__

#ifndef __PhysicsObject_h__
#include "PhysicsObject.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __Float_h__
#include "Float.h"
#endif

class BoundingBox;

// An object with no physics, no state information.  Take a subclass of this
// and connect links to it to represent a set of PhysicsObjects fairly
// efficiently, while dealing automatically with updating the set when things
// are deleted.
class NullObject
  : public PhysicsObject
{
public:
  NullObject ();
  int stateSize () const;
  bool physicsIntersect (const Float *state, const BoundingBox &box)
    const;
  void plausibleState (Dynavec <Float> &result) const;
  Vec3 boundingSphereCenter (const Float *state) const;
  Float physicsBoundingSphereRadius () const;
  bool isPhysicsBounded () const;
  void translate (Float *state, const Vec3 &v) const;
  void rotate (Float *state, const Quaternion &q) const;
  bool exempt () const;
  // The default implementation for doPhysics does nothing, which is
  // appropriate here, so don't define a new doPhysics here.
  const char *classId ()const;
  static const char *const staticClassId;
  bool isInstanceOf (const char *const classId) const;
  // Next one returns false.
  bool isSelectable () const;
};

#endif
