// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __NullObject_h__
#include "NullObject.h"
#endif

#ifndef __SimpleConfiguration_h__
#include "SimpleConfiguration.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __BoundingBox_h__
#include "BoundingBox.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __TheObjectDrawerFactory_h__
#include "TheObjectDrawerFactory.h"
#endif

#ifndef __Quaternion_h__
#include "Quaternion.h"
#endif

NullObject::NullObject ()
  : PhysicsObject ("Null", NEW (SimpleConfiguration ()))
{}

int NullObject::stateSize () const {
  return 0;
}

bool NullObject::physicsIntersect (const Float *state, const BoundingBox &box)
  const {
  (void) state; (void) box;
  return false;
}

void NullObject::plausibleState (Dynavec <Float> &result) const {
  result.extendTo (stateSize ());
}

Vec3 NullObject::boundingSphereCenter (const Float *state) const {
  (void) state;
  return Vec3 (0,0,0);
}

Float NullObject::physicsBoundingSphereRadius () const {
  return 0;
}

bool NullObject::isPhysicsBounded () const {
  return true;
}

void NullObject::translate (Float *state, const Vec3 &v) const {
  (void) state; (void) v;
  // Do nothing.
}

void NullObject::rotate (Float *state, const Quaternion &q) const {
  (void) state; (void) q;
  // Do nothing.
}

bool NullObject::exempt () const {
  return true;
}

const char *const NullObject::staticClassId = "NullObject";

const char *NullObject::classId () const {
  return staticClassId;
}

bool NullObject::isInstanceOf (const char *const classId) const {
  return staticClassId == classId;
}

bool NullObject::isSelectable () const {
  return false;
}

namespace {
  static const bool useless =
  (TheObjectDrawerFactory::registerObjectDrawer ("Null"),
   true);
}
