// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __InvisibilityMarker_h__
#define __InvisibilityMarker_h__

#ifndef __NullObject_h__
#include "NullObject.h"
#endif

// Drawers should have a special case: if an InvisibilityMarker has a link to
// another object, and the InvisibilityMarker's getVisible method returns
// false, then don't draw the object.  If we have multiple reasons not to draw
// an object because it is linked to by multiple false InvisibilityMarker's, we
// don't draw it.
//
// The drawer uses the isInstanceOf method to determine whether something is an
// InvisibilityMarker, so if you implement that method properly you can take a
// subclass of InvisibilityMarker and it will still be a functioning
// InvisibilityMarker.
class InvisibilityMarker
  : public NullObject
{
  struct InvisibilityMarkerData;
  InvisibilityMarkerData *m_data;
public:
  InvisibilityMarker ();
  ~InvisibilityMarker ();
  static const char * const staticClassId;
  const char *classId () const;
  bool isInstanceOf (const char *const classId) const;
  // A physics object is deemed to change when its appearance or physics
  // changes.  This object has no appearance or physics, and setVisible doesn't
  // change that, so it's a const method.  This class has to be implemented
  // with a mutable instance variable.
  void setVisible (bool visible) const;
  // Return the last value passed to setVisible, or return true if setVisible
  // has never been called.
  bool getVisible () const;
};

#endif
