// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __GenericObjectDrawer_h__
#include "GenericObjectDrawer.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __ObjectDrawerConfiguration_h__
#include "ObjectDrawerConfiguration.h"
#endif

#ifndef __ConstantRecursiveSlotValue_h__
#include "ConstantRecursiveSlotValue.h"
#endif

#ifndef __OneObjectDrawerConfiguration_h__
#include "OneObjectDrawerConfiguration.h"
#endif

#ifndef __Configurable_h__
#include "Configurable.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

namespace {
  class ObjectDrawerFactory
    : public Factory
  {
    String m_windowSystem;
  public:
    ObjectDrawerFactory (const String &windowSystem)
      : Factory (windowSystem+"ObjectDrawer"),
	m_windowSystem (windowSystem)
    {}
    SP<Configuration> defaultConfiguration () const {
      return NEW (ObjectDrawerConfiguration (m_windowSystem));
    }
    SP<Configurable> makeIt (SP<Configuration> c) const {
      SP<ObjectDrawerConfiguration> odconf =
	dynamic_cast <ObjectDrawerConfiguration *> (&*c);
      assert (odconf);
      SP<ConstantRecursiveSlotValue> crsv =
	dynamic_cast <ConstantRecursiveSlotValue *>
	(&*odconf->getSlot (odconf->getClassName()));
      assert (crsv);
      SP<OneObjectDrawerConfiguration> oodconf =
	dynamic_cast <OneObjectDrawerConfiguration *>
	(crsv->getConfiguration ());
      assert (oodconf);
      oodconf->setPhysicsObjectConfiguration
	(odconf->getPhysicsObjectConfiguration ());
      return crsv->makeIt ();
    }
  };
};

// FIXME Can't have a PhysicsObject called "Object"
// Because OGLObjectDrawer is the factory that makes OGLBallDrawer,
// OGLDiskDrawer, etc.
// FIXME Names of pieces run together in factory, hence ambiguity.
//
// For example, window system OGLB, object all vs window system OGL, object
// Ball.
//
// A fix would be to have an underscore in the name and to have a convention
// (and an assertion) that window systems don't have underscores in their
// names.
void GenericObjectDrawer::registerWindowSystem (const String &windowSystem) {
  FactoryTable::store ("ObjectDrawer",
		       NEW (ObjectDrawerFactory (windowSystem)));
}
