// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#include "DiskConfiguration.h"

#ifndef __Float_h__
#include "Float.h"
#endif

#ifndef __Color_h__
#include "Color.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __myassert_h__
#include "myassert.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

struct DiskConfiguration::DiskConfigurationData {
  Float m_radius;
  Color m_material;
  Vec3 m_defaultNorm;
};

DiskConfiguration::DiskConfiguration () :
  m_data (NEW (DiskConfigurationData ()))
{
  m_data->m_radius = 5.0;
  m_data->m_material = Color (0, 0.8, 0, 1.0);
  m_data->m_defaultNorm = Vec3 (0, 0, 1);
}

DiskConfiguration::DiskConfiguration (const DiskConfiguration &d)
  : Configuration (d),
    m_data (NEW (DiskConfigurationData (*d.m_data)))
{}

DiskConfiguration::~DiskConfiguration () {
  assert (m_data);
  delete m_data;
  m_data = 0;
}

SP<Configuration> DiskConfiguration::copy () const {
  return NEW (DiskConfiguration (*this));
}

void DiskConfiguration::setMaterial (const Color & material) {
  m_data->m_material = material;
}

Color DiskConfiguration::getMaterial () const {
  return m_data->m_material;
}

void DiskConfiguration::setRadius (Float radius) {
  m_data->m_radius = radius;
}

Float DiskConfiguration::getRadius () const {
  return m_data->m_radius;
}

void DiskConfiguration::setDefaultNorm (const Vec3 &v) {
  m_data->m_defaultNorm = v.makeUnit ();
}

Vec3 DiskConfiguration::getDefaultNorm () const {
  return m_data->m_defaultNorm;
}

bool DiskConfiguration::hasTheSameTypeAs (const Configuration *c) const
{
  return 0 != dynamic_cast <const DiskConfiguration *> (c);
}
