// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Disk_h__
#define __Disk_h__

#ifndef __Float_h__
#include "Float.h"
#endif

#ifndef __PhysicsObject_h__
#include "PhysicsObject.h"
#endif

#ifndef __Vec3_h__
#include "Vec3.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

class DiskConfiguration;

class Disk: public PhysicsObject {
  Vec3 m_defaultNorm;
 public:
  Disk (SP<DiskConfiguration> d);
  int stateSize () const;
  void plausibleState (Dynavec <Float> &result) const;
  bool physicsIntersect (const Float *state, const BoundingBox &box)
    const;

  Vec3 boundingSphereCenter (const Float *state) const;
  Float physicsBoundingSphereRadius () const; // Aborts.
  bool isPhysicsBounded () const; // returns false.
  
  void translate (Float *state, const Vec3 &v) const;
  void rotate (Float *state, const Quaternion &q) const;
  bool exempt () const;
  static inline Vec3 center (const Float *state) {
    return Vec3 (state);
  }
  static inline Vec3 normUnit (const Float *state) {
    Vec3 r1 (state + 3);
    assert (0.99 < r1.length() && r1.length() < 1.01);
    return r1;
  }
  static void setCenter (Float *state, const Vec3 &v);
  // Next one normalizes v before setting.
  static void setNorm (Float *state, const Vec3 &v);
  static const char *const staticClassId;
  const char *classId () const;
  bool isInstanceOf (const char *classId) const;
};

#endif
