// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//
#ifndef __DDPOConfiguration_h__
#define __DDPOConfiguration_h__

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __SP_h__
#include "SP.h"
#endif

class MenuSlotValueChoices;
class String;
class MenuSlotValue;
class DDPOConfiguration
// DDPO = DrawingDelegatingPhysicsObject.  A DDPOConfiguration says which
// drawing scheme to use.
  : public Configuration
{
  SP<MenuSlotValue> getMenuSlot ();
  SP<const MenuSlotValue> getMenuSlot () const;
public:
  // The "default" argument is the shortName of the default choice to take from
  // MenuSlotValueChoices.
  DDPOConfiguration (MenuSlotValueChoices *choices);
  // The presently selected drawing method.  This will be a shortName from
  // the MenuSlotValueChoices.
  const String getDrawerName () const;
  void setDrawerName (const String &name);
  void setDrawerPos (int pos);
  // When this integer changes, caches that think they know the number of
  // choices will need to be regenerated.
  int generation () const;
  // The number of possible drawers.  If this changes, then generation had
  // better change too.
  int numAlternatives () const;
  // The position of the current drawer in the vector of possibilities.
  int currentDrawerPos () const;
  SP<Configuration> copy () const;
  bool hasTheSameTypeAs (const Configuration *c) const;
};
#endif
