// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//
#ifndef __DDPOConfiguration_h__
#include "DDPOConfiguration.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __MemoryUtil_h__
#include "MemoryUtil.h"
#endif

#ifndef __MenuSlotValue_h__
#include "MenuSlotValue.h"
#endif

#ifndef __MenuSlotValueChoices_h__
#include "MenuSlotValueChoices.h"
#endif

namespace {
  String drawingStyleName () {
    return "Drawing style";
  }
}

SP<MenuSlotValue> DDPOConfiguration::getMenuSlot () {
  return MenuSlotValue::getSlotValue (this, drawingStyleName ());
}

SP<const MenuSlotValue> DDPOConfiguration::getMenuSlot () const {
  return MenuSlotValue::getSlotValue (this, drawingStyleName ());
}

DDPOConfiguration::DDPOConfiguration (MenuSlotValueChoices *choices) {
  initializeSlot (drawingStyleName (), NEW (MenuSlotValue (choices)));
}

const String DDPOConfiguration::getDrawerName () const {
  return getMenuSlot () -> getShortStringChoice ();
}

void DDPOConfiguration::setDrawerName (const String &name) {
  return getMenuSlot () -> setShortStringChoice (name);
}

void DDPOConfiguration::setDrawerPos (int pos) {
  return getMenuSlot () -> setIntChoice (pos);
}

int DDPOConfiguration::generation () const {
  return getMenuSlot () -> getChoices () -> generation ();
}

int DDPOConfiguration::numAlternatives () const {
  return getMenuSlot () -> getChoices () -> size ();
}

int DDPOConfiguration::currentDrawerPos () const {
  return getMenuSlot () -> getIntChoice ();
}

SP<Configuration> DDPOConfiguration::copy () const {
  return NEW (DDPOConfiguration (*this));
}

bool DDPOConfiguration::hasTheSameTypeAs (const Configuration *c) const {
  return 0 != dynamic_cast <const DDPOConfiguration *> (c);
}
