// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#include "BouncingBallConfiguration.h"

#ifndef __Float_h__
#include "Float.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __BoolSlotValue_h__
#include "BoolSlotValue.h"
#endif

// Don't have a static variable with a string, it looks like a memory leak.
static String randomVelocities () {
  return "Randomize velocities";
}

BouncingBallConfiguration::BouncingBallConfiguration () {
  m_gravity = 1;
  m_mass = 1;
  m_stiffness = 1;
  initializeSlot (randomVelocities(), NEW (BoolSlotValue (true)));
}

void BouncingBallConfiguration::setGravity (Float gravity) {
  m_gravity = gravity;
}

Float BouncingBallConfiguration::getGravity () const {
  return m_gravity;
}

void BouncingBallConfiguration::setMass (Float mass) {
  m_mass = mass;
}

Float BouncingBallConfiguration::getMass () const {
  return m_mass;
}

void BouncingBallConfiguration::setStiffness (Float stiffness) {
  m_stiffness = stiffness;
}

Float BouncingBallConfiguration::getStiffness () const {
  return m_stiffness;
}

bool BouncingBallConfiguration::getRandomVelocities () const {
  return BoolSlotValue::getSlot (this, randomVelocities());
}

void BouncingBallConfiguration::setRandomVelocities (bool b) {
  BoolSlotValue::setSlot (this, randomVelocities(), b);
}

SP<Configuration> BouncingBallConfiguration::copy () const {
  return NEW (BouncingBallConfiguration (*this));
}

bool BouncingBallConfiguration::hasTheSameTypeAs (const Configuration *c) const
{
  return 0 != dynamic_cast <const BouncingBallConfiguration *> (c);
}
