// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __Float_h__
#include "Float.h"
#endif

#ifndef __Dynavec_h__
#include "Dynavec.h"
#endif

#ifndef __BoringBallConfiguration_h__
#include "BoringBallConfiguration.h"
#endif

#ifndef __BoundingSphere_h__
#include "BoundingSphere.h"
#endif

#ifndef __Float_h__
#include "Float.h"
#endif

#ifndef __Ball_h__
#include "Ball.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __BoundingBox_h__
#include "BoundingBox.h"
#endif

#ifndef __BoringBall_h__
#include "BoringBall.h"
#endif

BoringBall::BoringBall (SP<BoringBallConfiguration> b) : Ball (&*b)
{}

bool BoringBall::exempt () const {
  return true;
}

bool BoringBall::isPhysicsBounded () const {
  return true;
}

BoundingSphere BoringBall::physicsBoundingSphere (const Float *state) const
{
  // No physics, so zero radius bounding sphere.  This still will
  // give interactions with other objects that overlap the center of
  // the BoringSphere; oh well.  
  return BoundingSphere (0, Vec3 (state));
}

bool BoringBall::physicsIntersect (const Float *state,
				   const BoundingBox &box)
  const
{
  (void) state; (void) box;
  return false;
}

bool BoringBall::isInstanceOf (const char *classId) const {
  // We avoid a jump by using | instead of || here.
  return (staticClassId == classId) | (Ball::staticClassId == classId);
}

void BoringBall::plausibleState (Dynavec <Float> &result) const {
  result.extendTo (0);
  result.extendTo (stateSize (), 0);
}

Float BoringBall::physicsBoundingSphereRadius () const {
  return 0;
}

const char *const BoringBall::staticClassId = "BoringBall";

const char *BoringBall::classId () const {
  return BoringBall::staticClassId;
}

namespace {

  class BoringBallFactory
    : public Factory
  {
  public:
    BoringBallFactory () : Factory ("BoringBall")
    {}
    SP<Configuration> defaultConfiguration () const {
      SP<BoringBallConfiguration> result = NEW (BoringBallConfiguration());
      return &*result;
    }
    SP<Configurable> makeIt (SP<Configuration> c) const {
      BoringBallConfiguration *conf = dynamic_cast <BoringBallConfiguration *> (&*c);
      assert (conf);
      return NEW (BoringBall (conf));
    }
  };
  
  static const bool useless =
  (FactoryTable::store ("Ball", NEW (BoringBallFactory ())),
   true);
};
