// Fungimol - an extensible system for designing atomic-scale objects.
// Copyright (C) 2000 Tim Freeman
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library in the file COPYING.txt; if not,
// write to the Free Software Foundation, Inc., 59 Temple Place -
// Suite 330, Boston, MA 02111-1307, USA
//
// The author can be reached by email at tim@infoscreen.com, or by
// paper mail at:
//
// Tim Freeman
// 655 S. FairOaks Ave., Apt B-316
// Sunnyvale, CA 94086
//

#ifndef __BouncingBall_h__
#include "BouncingBall.h"
#endif

#ifndef __FactoryTable_h__
#include "FactoryTable.h"
#endif

#ifndef __BouncingBallConfiguration_h__
#include "BouncingBallConfiguration.h"
#endif

#ifndef __BouncingBall_h__
#include "BouncingBall.h"
#endif

#ifndef __Configuration_h__
#include "Configuration.h"
#endif

#ifndef __Factory_h__
#include "Factory.h"
#endif

#ifndef __String_h__
#include "String.h"
#endif

#ifndef __Color_h__
#include "Color.h"
#endif

namespace {
  class BlueBouncingBallFactory : public Factory {
  public:
    BlueBouncingBallFactory () : Factory ("BlueBouncingBall")
    {}
    SP<Configuration> defaultConfiguration () const {
      SP<BouncingBallConfiguration> result = NEW (BouncingBallConfiguration());
      result->setVisibleRadius (1.0);
      result->setMaterial (Color (0.0, 0.0, 1.0, 1.0));
      result->setStiffness (10);
      result->setMass (8);
      return &*result;
    }
    SP<Configurable> makeIt (const SP<Configuration> c) const {
      BouncingBallConfiguration *conf =
	dynamic_cast <BouncingBallConfiguration *> (&*c);
      assert (conf);
      return NEW (BouncingBall (conf));
    }
  };
  
  static const bool useless =
  (FactoryTable::store ("BlueBouncingBall", NEW (BlueBouncingBallFactory ())),
   FactoryTable::registerSubclass ("BlueBouncingBall", "BouncingBall"),
   true);

}
